/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/  

/**
 * \file    DM814x_McASP.h
 *
 * \brief   Defines the module register defines for McASP
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM814x McASP controller.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM814x_McASP_H_
#define _DM814x_McASP_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_SoC.h"
#include "DM814x_types.h"

/**
@addtogroup DM814x McASP
@{
*/

/*
 *====================
 * Defines
 *====================
 */
#define DM814X_MCASP0_BASE					(0x48038000u)
/**< McASP 0 Base address				                               */
#define DM814X_MCASP1_BASE					(0x4803C000u)
/**< McASP 1 Base address				                               */
#define DM814X_MCASP2_BASE					(0x48050000u)
/**< McASP 2 Base address				                               */
#define DM814X_MCASP3_BASE					(0x4A1A2000u)
/**< McASP 3 Base address				                               */
#define DM814X_MCASP4_BASE					(0x4A1A8000u)
/**< McASP 4 Base address				                               */
#define DM814X_MCASP5_BASE					(0x4A1AE000u)
/**< McASP 5 Base address				                               */
 
#define MCASP_PID_OFFSET             		(0x00000000u)
/**< Offset of the Peripheral ID register                               */
#define MCASP_PWRIDLESYSCONFIG_OFFSET       (0x00000004u)
/**< Offset of the Power IDLE SYSCONFIG register                        */
#define MCASP_PFUNC_OFFSET             		(0x00000010u)
/**< Offset of the Pin Function Control register                        */
#define MCASP_PDIR_OFFSET             		(0x00000014u)
/**< Offset of the Pin Direction Control register                       */
#define MCASP_PDOUT_OFFSET             		(0x00000018u)
/**< Offset of the Pin Data out register                          		*/
#define MCASP_PDSET_OFFSET             		(0x0000001Cu)
/**< Offset of the Pin Data Set register                                */
#define MCASP_PDCLR_OFFSET             		(0x00000020u)
/**< Offset of the Pin Data Clear register                          	*/
#define MCASP_GBLCTL_OFFSET             	(0x00000044u)
/**< Offset of the Global Control register                          	*/
#define MCASP_AMUTE_OFFSET             		(0x00000048u)
/**< Offset of the Audio Mute Control register                          */
#define MCASP_DLBCTL_OFFSET             		(0x0000004Cu)
/**< Offset of the Loop Back test Control register                      */
#define MCASP_DITCTL_OFFSET             	(0x00000050u)
/**< Offset of the Transmit DIT Mode Control register                   */
#define MCASP_RGBLCTL_OFFSET             	(0x00000060u)
/**< Offset of the Global Control register alias for Receiver			*/
#define MCASP_RMASK_OFFSET             	(0x00000064u)
/**< Offset of the Receiver Mask register                          		*/
#define MCASP_RFMT_OFFSET             		(0x00000068u)
/**< Offset of the Receive Format Control register                      */
#define MCASP_AFSRCTL_OFFSET             	(0x0000006Cu)
/**< Offset of the Frame Sync Control register for Receiver				*/
#define MCASP_ACLKRCTL_OFFSET             	(0x00000070u)
/**< Offset of the Receive Clock Control register                       */
#define MCASP_AHCLKRCTL_OFFSET             	(0x00000074u)
/**< Offset of the High frequency Receive Clock conrol register         */
#define MCASP_RTDM_OFFSET             		(0x00000078u)
/**< Offset of the TDM Slot for Receive									*/
#define MCASP_RINTCTL_OFFSET             	(0x0000007Cu)
/**< Offset of the Receive Event Clear register                         */
#define MCASP_RSTAT_OFFSET             	(0x00000080u)
/**< Offset of the Receive Status register		                        */
#define MCASP_RSLOT_OFFSET             	(0x00000084u)
/**< Offset of the Current active Receive TDM Slot register             */
#define MCASP_RCLKCHK_OFFSET             	(0x00000088u)
/**< Offset of the Receive Clock check control register             	*/
#define MCASP_REVTCTL_OFFSET             	(0x00000088u)
/**< Offset of the Receive DMA Event register             				*/
#define MCASP_XGBLCTL_OFFSET             	(0x000000A0u)
/**< Offset of the Transmit Global Control register             		*/
#define MCASP_XMASK_OFFSET             	(0x000000A4u)
/**< Offset of the Transmit Mask register             		*/
#define MCASP_XFMT_OFFSET             	(0x000000A8u)
/**< Offset of the Transmit Fromat Control register             		*/
#define MCASP_AFSXCTL_OFFSET             	(0x000000ACu)
/**< Offset of the Transmit Frame Sync Control register             		*/
#define MCASP_ACLKXCTL_OFFSET             	(0x000000B0u)
/**< Offset of the Transmit Clock Control register             		*/
#define MCASP_AHCLKXCTL_OFFSET             	(0x000000B4u)
/**< Offset of the Transmit High freq clock Control register             		*/
#define MCASP_XTDM_OFFSET             	(0x000000B8u)
/**< Offset of the Transmit TDM slot control register             		*/
#define MCASP_XINTCTL_OFFSET             	(0x000000BCu)
/**< Offset of the Transmit Interrupt Control register             		*/
#define MCASP_XSTAT_OFFSET             	(0x000000C0u)
/**< Offset of the Transmit status register             		*/
#define MCASP_XSLOT_OFFSET             	(0x000000C4u)
/**< Offset of the Current active Transmit TDM slot register             		*/
#define MCASP_XCLKCHK_OFFSET             	(0x000000C4u)
/**< Offset of the Transmit Clock check register             		*/


/* ------------------------------------------------------------------------ *
 *  GBLCTL_ Field Definitions                                               *
 * ------------------------------------------------------------------------ */
#define GBLCTL_XFRST_ON         0x1000
#define GBLCTL_XSMRST_ON        0x0800
#define GBLCTL_XSRCLR_ON        0x0400
#define GBLCTL_XHCLKRST_ON      0x0200
#define GBLCTL_XCLKRST_ON       0x0100
#define GBLCTL_RFRST_ON         0x0010
#define GBLCTL_RSMRST_ON        0x0008
#define GBLCTL_RSRCLR_ON        0x0004
#define GBLCTL_RHCLKRST_ON      0x0002
#define GBLCTL_RCLKRST_ON       0x0001

/*
 *====================
 * Structures
 *====================
 */
/**
 * \brief Register Overlay structure for McASP registers
 *
 *  Register Overlay structure for McASP registers
 */
typedef struct
{
	UINT32		u32REVID;				/**< Revision ID for the peripheral */
	UINT32		u32PWRIDLESYSCON; 		/**< Power Idle sys config register */
	UINT32		u32Reserved008;
	UINT32		u32Reserved00c;
	UINT32		u32PINFUNC;				/**< Pin function contrl register */
	UINT32		u32PDIR; 				/**< Pin direction control register */
	UINT32		u32PDOUT;				/**< Pin data output register */
	UINT32		u32PDSET;				/**< Pin Data set register */
	UINT32		u32PDCLR;				/**< Pin data clear regisger */
	UINT32		u32Reserved024;
	UINT32		u32Reserved028;
	UINT32		u32Reserved02C;
	UINT32		u32Reserved030;
	UINT32		u32Reserved034;
	UINT32		u32Reserved038;
	UINT32		u32Reserved03C;
	UINT32		u32Reserved040;
	UINT32		u32GBLCTL;				/**< Global Control register */
	UINT32		u32AMUTE;				/**< AMUTE control register */
	UINT32		u32DLBCTL;				/**< Digital Loop-back mode test register */
	UINT32		u32DITCTL;				/**< Transmit DIT mode control register */
	UINT32		u32Reserved054;
	UINT32		u32Reserved058;
	UINT32		u32Reserved05C;
	UINT32		u32RGBLCTL;				/**< Receive Global control register */
	UINT32		u32RMASK;				/**< Recieve Mask register */
	UINT32		u32RFMT;				/**< Receive Fromat regisetr */
	UINT32		u32AFSRCTL;				/**< Receive Frame Sync control register */
	UINT32		u32ACLKRCTL;			/**< Receive Clock control register */
	UINT32		u32AHCLKRCTL;			/**< Receive High freq Clock control register */
	UINT32		u32RTDM;				/**< Receive TDM Slot 0-31 register */
	UINT32		u32RINTCTL;				/**< Receive Event clear register*/
	UINT32		u32RSTAT;				/**< Receive Status register */
	UINT32		u32RSLOT;				/**< Receive Slot register */
	UINT32		u32RCLKCHK;
	UINT32		u32REVTCTL;
	UINT32		u32Reserved090;
	UINT32		u32Reserved094;
	UINT32		u32Reserved098;
	UINT32		u32Reserved09C;
	UINT32		u32XGBLCTL;
	UINT32		u32XMASK;
	UINT32		u32XFMT;
	UINT32		u32AFSXCTL;
	UINT32		u32ACLKXCTL;
	UINT32		u32AHCLKXCTL;
	UINT32		u32XTDM;
	UINT32		u32XINTCTL;
	UINT32		u32XSTAT;
	UINT32		u32XSLOT;
	UINT32		u32XCLKCHK;
	UINT32		u32XEVTCTL;
	UINT32		u32Reserved0D0_0FC[44];
	UINT32		u32SRCTL0;
	UINT32		u32SRCTL1;
	UINT32		u32SRCTL2;
	UINT32		u32SRCTL3;
	UINT32		u32SRCTL4;
	UINT32		u32SRCTL5;
	UINT32		u32SRCTL6;
	UINT32		u32SRCTL7;
	UINT32		u32SRCTL8;
	UINT32		u32SRCTL9;
	UINT32		u32SRCTL10;
	UINT32		u32SRCTL11;
	UINT32		u32SRCTL12;
	UINT32		u32SRCTL13;
	UINT32		u32SRCTL14;
	UINT32		u32SRCTL15;
	UINT32		u32Reserved1C0_1FC[16];
	UINT32		u32XBUF0;
	UINT32		u32XBUF1;
	UINT32		u32XBUF2;
	UINT32		u32XBUF3;
	UINT32		u32XBUF4;
	UINT32		u32XBUF5;
	UINT32		u32XBUF6;
	UINT32		u32XBUF7;
	UINT32		u32XBUF8;
	UINT32		u32XBUF9;
	UINT32		u32XBUF10;
	UINT32		u32XBUF11;
	UINT32		u32XBUF12;
	UINT32		u32XBUF13;
	UINT32		u32XBUF14;
	UINT32		u32XBUF15;
	UINT32		u32Reserved240_27C[16];
	UINT32		u32RBUF0;
	UINT32		u32RBUF1;
	UINT32		u32RBUF2;
	UINT32		u32RBUF3;
	UINT32		u32RBUF4;
	UINT32		u32RBUF5;
	UINT32		u32RBUF6;
	UINT32		u32RBUF7;
	UINT32		u32RBUF8;
	UINT32		u32RBUF9;
	UINT32		u32RBUF10;
	UINT32		u32RBUF11;
	UINT32		u32RBUF12;
	UINT32		u32RBUF13;
	UINT32		u32RBUF14;
	UINT32		u32RBUF15;	
} _DM814x_MCASP_REGS_, *DM814x_MCASP_REGS;


/* @} */   /* End of DM814x McASP */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_McASP_H_ */
